#pragma rtGlobals=1		// Use modern global access method.
#pragma rtGlobals=1		// Use modern global access method.
#include  <New Polar Graphs>
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												1 ELECTRON
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    

Macro Macro1e_fine(particle,xg,yg,tp0,t0,E,B)
	variable xg =32
	variable yg= 32
	variable tp0 =3708
	variable t0 = 32
	variable E=28
	variable B= 16.5
	String particle="e1"	
	Prompt particle, "Particle label"
	Prompt xg, "X center"
	Prompt yg, "Y center"
	Prompt tp0, "Measured TOF"
	Prompt t0, "Real TOF (ns)"
	Prompt E, "Electric Field (V/cm)"
	Prompt B, "Magnetic Field (Gauss)"

	macro1e_EB_fine(particle,xg,yg,tp0,t0,E,B)
End


Proc macro1e_EB_fine(particle,xg,yg,tp0,t0,E,B)
	String particle	
	variable xg, yg,tp0,t0,E,B
	
	variable tau,WaveSize

	Variable timerRefNum, microSeconds	
	Silent 1;
	Print "============= Start Conversion  Particle : ",particle,"============= "
	timerRefNum = startMSTimer

	tau=tp0/2+t0
	WaveSize=numpnts($("x_"+particle))
	make/O/D/N=(Wavesize)$("px_"+particle),$("py_"+particle),$("pz_"+particle)

	//Calcul Momenta
	duplicate/O $("x_"+particle) $("x_"+particle+"_xci")
	duplicate/O $("y_"+particle) $("y_"+particle+"_yci")
	
	$("x_"+particle+"_xci")=$("x_"+particle)-(-xci)   //OK 8/2/05
	$("y_"+particle+"_yci")=$("y_"+particle)-(-yci)   //OK 8/2/05
	
	Px_EB($("x_"+particle+"_xci"),$("y_"+particle+"_yci"),$("t_"+particle),xg,yg,tau,B,$("px_"+particle))
	Py_EB($("x_"+particle+"_xci"),$("y_"+particle+"_yci"),$("t_"+particle),xg,yg,tau,B,$("py_"+particle))
	Pz_Elin($("t_"+particle),tp0,E,$("pz_"+particle))	
	Histo_Momenta(particle,"",-200,200,50, 30)
	microSeconds = stopMSTimer(timerRefNum)	
	Print "Momenta Calculation Elapse Time (Sec)=", microSeconds/1e6	
	
	timerRefNum = startMSTimer
	// Calcul Energy-Angle

	AngleEnergy(particle)
	microSeconds = stopMSTimer(timerRefNum)	
	Print "Angles & Energy Calculation Elapse Time (Sec)=", microSeconds/1e6	
	
End
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												2 ELECTRONS
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    
Macro Macro2e_fine(particle1, particle2,xg,yg,tp0,t0,E,B)
	variable xg =32
	variable yg= 32
	variable tp0 =1800
	variable t0 = 28
	variable E=35
	variable B= 19
	String particle1="e1"	
	String particle2="e2"
	Prompt particle1, "1rst particle label"
	Prompt particle2, "2nd particle label"
	Prompt xg, "X center"
	Prompt yg, "Y center"
	Prompt tp0, "Measured TOF"
	Prompt t0, "Real TOF (ns)"
	Prompt E, "Electric Field (V/cm)"
	Prompt B, "Magnetic Field (Gauss)"

	macro2e_EB_fine(particle1, particle2,xg,yg,tp0,t0,E,B)
End




Proc macro2e_EB_fine(particle1,particle2, xg,yg,tp0,t0,E,B)
	String particle1,particle2
	variable xg,yg,tp0,t0,B,E	
	
	Variable timerRefNum, microSeconds
	Silent 1;		
	
	macro1e_EB_fine(particle1,xg,yg,tp0,t0,E,B)
	macro1e_EB_fine(particle2,xg,yg,tp0,t0,E,B)
	
	Print "============= Correlate Particles ============= "
	timerRefNum = startMSTimer
	Correlation(particle1,particle2)
	microSeconds = stopMSTimer(timerRefNum)	
	Print "Correlation Calculation Elapse Time (Sec)=", microSeconds/1e6	
End



//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												1 ION     7/02/05
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    
Macro Macro1i_fine(particle1, xg,yg,tp0,t0,K2,K0, Kt0, kt2)
	variable xg =32
	variable yg= 32
	variable tp0 =1355
	variable t0 = 820
	variable K0=0.13
	variable K2= 5000
	variable Kt0=-60
	variable Kt2= 3.2
	String particle1="i1"	
	Prompt particle1, "1rst particle label"
	Prompt xg, "X center"
	Prompt yg, "Y center"
	Prompt tp0, "Measured TOF"
	Prompt t0, "Real TOF (ns)"
	Prompt K2 "Transverse Magnification (0 order)"
	Prompt K0, "Transverse Magnification (1 order)"
	Prompt Kt0, "Longitudinal Constant (0 order)"
	Prompt Kt2 "Longitudinal Constant (1 order)"

	macro1i_lens_fine(particle1, xg,yg,tp0,t0,K0,K2,kt0, Kt2)
End




function macro1i_Lens_fine(particle1,  xg,yg,tp0,t0,K0,K2,Kt,Kt2)
	String particle1
	variable xg, yg, tp0, t0,K0,K2,Kt,Kt2
	variable NbPoints,kk=0, delta, xx,yy,tt
	variable tau=tp0/2+t0
	variable m=1
	WAVE x_i1=x_i1,y_i1=y_i1, t_i1=t_i1

	duplicate/o x_i1 px_i1,py_i1,pz_i1, xci,yci
	
       variable au=0.6*10*sqrt(10) 
	NbPoints=numpnts(x_i1)
	for (kk=0; kk<Nbpoints; kk+=1)
		// x and y momenta of ions (Physically the first detected ion is labelled t_i2,x_i2,y_i2 in Common Stop mode of the TDC)
		yy=(x_i1[kk]-xg)*au
		xx=(y_i1[kk]-yg)*au
		tt=-t_i1[kk]/2+tau
		px_i1[kk]=xx*sqrt(K2/tt^2+K0)   // without lens K0=0
		py_i1[kk]=yy*sqrt(K2/tt^2+K0)  
		
		// source point coordinates       added on 21/12/04 to be used for electron treatment in macro2e_fine
		//  assuming that the magnifying factor is m
	
		yci[kk]=(x_i1[kk]-xg)/m
		xci[kk]=(y_i1[kk]-yg)/m	
		
		// z momenta at the second order (linear approx. not good enough)
		delta=(Kt)^2+4*(tp0-t_i1[kk])/2*Kt2
		pz_i1[kk]= (-Kt-sqrt(delta))/(2*Kt2)*au/0.6
	endfor
	
	Silent 1;
	Execute ("Histo_Momenta(\""+particle1+"\",\"\",-200,200,50, 30)")
	// Calcul Energy-Angle
	Execute ("AngleEnergy(\""+particle1+"\")")
	
end
       	      
//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												2 IONS
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    

Macro Macro2i_fine(particle1,particle2, xg,yg,tp0,t0,K2,K0, Kt0, kt2)
	variable xg =32
	variable yg= 32
	variable tp0 =1006
	variable t0 = 580
	variable K0=0.13
	variable K2= 5000
	variable Kt0=-60
	variable Kt2= 3.2
	String particle1="i1"	
	String particle2="i2"
	Prompt particle1, "1rst particle label"
	Prompt particle2, "2nd particle label"
	Prompt xg, "X center"
	Prompt yg, "Y center"
	Prompt tp0, "Measured TOF"
	Prompt t0, "Real TOF (ns)"
	Prompt K2 "Transverse Magnification (0 order)"
	Prompt K0, "Transverse Magnification (1 order)"
	Prompt Kt0, "Longitudinal Constant (0 order)"
	Prompt Kt2 "Longitudinal Constant (1 order)"

	macro2i_lens_fine(particle1,particle2, xg,yg,tp0,t0,K0,K2,kt0, Kt2)
End


function macro2i_Lens_fine(particle1, particle2, xg,yg,tp0,t0,K0,K2,Kt,Kt2)
	String particle1, particle2
	variable xg, yg, tp0, t0,K0,K2,Kt,Kt2
	variable NbPoints,kk=0, delta, xx,yy,tt
	variable tau=tp0/2+t0
	variable m=1
	WAVE x_i1=x_i1,y_i1=y_i1, t_i1=t_i1
	WAVE x_i2=x_i2,y_i2=y_i2, t_i2=t_i2

	duplicate/o x_i1 px_i1,py_i1,pz_i1, xci
	duplicate/o x_i1 px_i2,py_i2,pz_i2, yci
       variable au=0.6*10*sqrt(10) 
	NbPoints=numpnts(x_i1)
	for (kk=0; kk<Nbpoints; kk+=1)
		// x and y momenta of ions (Physically the first detected ion is labelled t_i2,x_i2,y_i2 in Common Stop mode of the TDC)
		yy=(x_i1[kk]-xg)*au
		xx=(y_i1[kk]-yg)*au
		tt=-t_i1[kk]/2+tau
		px_i1[kk]=xx*sqrt(K2/tt^2+K0)   // without lens K0=0
		py_i1[kk]=yy*sqrt(K2/tt^2+K0)  
		
		yy=(x_i2[kk]-xg)*au
		xx=(y_i2[kk]-yg)*au
		tt=-t_i2[kk]/2+tau		
		px_i2[kk]=xx*sqrt(K2/tt^2+K0)		
		py_i2[kk]=yy*sqrt(K2/tt^2+K0)
		
		// source point coordinates       added on 21/12/04 to be used for electron treatment in macro2e_fine
		//  assuming that the magnifying factor is m
	
		yci[kk]=((x_i1[kk]-xg)+(x_i2[kk]-xg))/(2*m)	
		xci[kk]=((y_i1[kk]-yg)+(y_i2[kk]-yg))/(2*m)	
		
		// z momenta at the second order (linear approx. not good enough)
		delta=(Kt)^2+4*(tp0-t_i1[kk])/2*Kt2
		pz_i1[kk]= (-Kt-sqrt(delta))/(2*Kt2)*au/0.6
		delta=(Kt)^2+4*(tp0-t_i2[kk])/2*Kt2
		pz_i2[kk]= (-Kt-sqrt(delta))/(2*Kt2)*au/0.6
	endfor
	
	Silent 1;
	Execute ("Histo_Momenta(\""+particle1+"\",\"\",-200,200,50, 30)")
	Execute ("Histo_Momenta(\""+particle2+"\",\"\",-200,200,50, 30)")
	// Calcul Energy-Angle
	Execute ("AngleEnergy(\""+particle1+"\")")
	Execute ("AngleEnergy(\""+particle2+"\")")
	Execute ("Correlation(\""+particle1+"\",\""+particle2+"\")")
	
end
       
       
       

